/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest;

import junit.framework.TestCase;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class TypeSafeMatcherTest
extends TestCase {
    private final Matcher<String> matcher = new TypeSafeMatcherSubclass();

    public void testCanDetermineMatcherTypeFromProtectedMatchesSafelyMethod() {
        TypeSafeMatcherTest.assertFalse((boolean)this.matcher.matches(null));
        TypeSafeMatcherTest.assertFalse((boolean)this.matcher.matches((Object)10));
    }

    public void testDescribesMismatches() {
        this.assertMismatchDescription("was null", null);
        this.assertMismatchDescription("was a java.lang.Integer (<3>)", new Integer(3));
        this.assertMismatchDescription("The mismatch", "a string");
    }

    private void assertMismatchDescription(String expectedDescription, Object actual) {
        StringDescription description = new StringDescription();
        this.matcher.describeMismatch(actual, (Description)description);
        TypeSafeMatcherTest.assertEquals((String)expectedDescription, (String)description.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeSafeMatcherSubclass
    extends TypeSafeMatcher<String> {
        public boolean matchesSafely(String item) {
            return false;
        }

        public void describeMismatchSafely(String item, Description mismatchDescription) {
            mismatchDescription.appendText("The mismatch");
        }

        public void describeTo(Description description) {
        }
    }
}

